package friendly.backend

import org.jetbrains.exposed.v1.core.Table
import org.jetbrains.exposed.v1.r2dbc.R2dbcDatabase
import org.jetbrains.exposed.v1.r2dbc.SchemaUtils
import org.jetbrains.exposed.v1.r2dbc.transactions.suspendTransaction

object UsersTable : Table("users") {
    private val idColumn = long("id").autoIncrement()
}

suspend fun main() {
    val url = System.getenv("FRIENDLY_DATABASE_URL")
        ?: error("Provide 'FRIENDLY_DATABASE_URL' env")

    val db = R2dbcDatabase.connect(
        url = url,
        driver = "postgresql",
    )

    suspendTransaction(db) {
        SchemaUtils.create(UsersTable)
    }
}
