local harpoon = require("projects.harpoon")
local gradle = require("projects.gradle")
local core = require("projects.core")

vim.cmd.tcd("~/Programming/friendly-backend/")

harpoon.attach_terminal {
    command = "source .nvim/env.run.sh && ./gradlew run -q --console=plain",
}

vim.cmd.Oil()

core.nvim_tabpage_create_user_command("C", function()
    gradle.make {
        command = "./gradlew assemble -q --console=plain"
    }
end, {})

core.nvim_tabpage_create_user_command("F", function()
    gradle.make {
        command = "./gradlew ktlintFormat --console=plain"
    }
end, {})

vim.api.nvim_create_autocmd('VimLeavePre', {
    callback = function()
        vim.cmd("!./gradlew --stop")
    end
})
