plugins {
    kotlin("jvm") version "2.2.0"
}

group = "net.yaranga"
version = "1.0-SNAPSHOT"

repositories {
    mavenCentral()
}

dependencies {
    implementation(kotlin("stdlib"))
    implementation(kotlin("reflect"))

    // exposed
    implementation("org.jetbrains.exposed:exposed-core:1.0.0-beta-5")
    implementation("org.jetbrains.exposed:exposed-dao:1.0.0-beta-5")
    implementation("org.jetbrains.exposed:exposed-r2dbc:1.0.0-beta-5")
    implementation("org.jetbrains.exposed:exposed-kotlin-datetime:1.0.0-beta-5")
    implementation("org.jetbrains.exposed:exposed-migration:1.0.0-beta-5")


    implementation("org.postgresql:r2dbc-postgresql:1.0.7.RELEASE")

    // coroutines
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-core:1.10.2")
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-jdk9:1.10.2")
    implementation("org.jetbrains.kotlinx:kotlinx-coroutines-debug:1.10.2")


    implementation("org.jetbrains.kotlinx:kotlinx-datetime:0.7.1")

    // tests

    testImplementation("org.junit.jupiter:junit-jupiter:5.13.4")
    testImplementation("org.jetbrains.kotlin:kotlin-test-junit5:2.2.0")

    testImplementation("org.testcontainers:junit-jupiter:1.21.3")
    testImplementation("org.testcontainers:postgresql:1.21.3")

    testImplementation(kotlin("stdlib"))
    testImplementation(kotlin("test"))
    testImplementation("org.jetbrains.kotlinx:kotlinx-coroutines-test:1.10.2")
}

tasks.test {
    useJUnitPlatform()
}

kotlin {
    jvmToolchain(21)
}