import com.nhaarman.mockito_kotlin.*
import org.junit.Test

open class Dependency {
    fun doOtherStuff(param: String) {
        println(param)
    }
}

class Service(val dep: Dependency) {
    fun doStuff() {
        dep.doOtherStuff("Hello")
    }
}

class Test {
    val dependency: Dependency = mock()
    val service = Service(dependency)

    @Test
    fun test() {
        service.doStuff()

        verify(dependency).doOtherStuff(any())
    }
}