import json
from flask import Flask
from flask_cors import CORS
from nlp import *
from create_insight import *
from uuid import uuid4
from copy import deepcopy


app = Flask(__name__)
CORS(app)

# Return the list of insights match user's input
@app.route('/search/<user_input>')
def search_insight(user_input):
	def build_url(insight_id):
		return host+"/analyze/#/"+workspace_id+"/"+insight_id
	# Convert '+' to space, currently we are expecting the query separate spaces by '+'
	user_input = user_input.split('+')
	user_input = ' '.join(user_input)
	# Refresh the catalog and insights list
	catalog, insights = get_cn_meta(workspace_id, host, token)
	titles, title2id = nlp_search(user_input, insights, 60)
	titles.append('Create Insight')
	title2url = {title:build_url(title2id[title]) for title in titles if title in title2id}
	return {'dropdown_list': titles, 'title2id': title2id, 'title2url':title2url}

# Trigger CN to create insight via API
@app.route('/create/<user_input>')
def create_insight(user_input):
	# Convert '+' to space, currently we are expecting the query separate spaces by '+'
	user_input = user_input.split('+')
	user_input = ' '.join(user_input)
	# Create a random hash for insight id
	insight_id = str(uuid4())
	# Obtain attributes, measures/metrics, filters
	insight_definitions = create_insight_definition(user_input, catalog)
	# Fill out the metadata for new insight
	result = create_insight_meta(user_input,insight_id,'',
		                         deepcopy(insight_t), deepcopy(measure_t), 
		                         deepcopy(attribute_t),
		                         insight_definitions['measures_meta'],
		                         insight_definitions['attribute_meta'],
		                         insight_definitions['viz_type'],
		                         insight_definitions['filter_meta'])
	# Make API call to create new insight
	execute_insight_creation(host, workspace_id, result)
	return {'title': user_input, 'id': insight_id}

# For testing purpose
@app.route('/delete/<user_input>')
def delete_testing_insight(user_input):
	delete_insight(host, workspace_id, user_input)
	return {'status': 'Successfully Deleted!'}

# CN Metadata
def get_cn_meta(workspace_id, host, token):
	cn = gd.GoodDataSdk.create(host,token)
	catalog = cn.catalog.get_full_catalog(workspace_id)
	insights = cn.insights.get_insights(workspace_id)
	return catalog, insights

host = 'http://' + CN_HOST
token = TOKEN
workspace_id = WORKSPACE_ID
catalog, insights = get_cn_meta(workspace_id, host, token)
insight_t, measure_t, attribute_t = read_templates()

if __name__ == '__main__':
	app.run(host=API_HOST, port=API_PORT, debug=True)
