/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.xenomachina.text.term;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import shadow.com.xenomachina.text.TextKt;
import shadow.com.xenomachina.text.term.TextTermKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003J\b\u0010\u000f\u001a\u00020\rH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\rH\u0002J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\bj\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lshadow/com/xenomachina/text/term/TextWrapper;", "", "maxWidth", "", "(I)V", "lineWidth", "newLinesSinceLastWord", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "word", "wordWidth", "addCodePoint", "", "inputCodePoint", "applyWordSeparator", "get", "", "goToNewLine", "handleLineFeed", "handleNonSpace", "handleSpace", "isNewParagraphRequired", "", "xenocom"})
public final class TextWrapper {
    private final StringBuilder sb;
    private final StringBuilder word;
    private int lineWidth;
    private int wordWidth;
    private int newLinesSinceLastWord;
    private final int maxWidth;

    public final void addCodePoint(int inputCodePoint) {
        if (Character.isSpaceChar(inputCodePoint) && inputCodePoint != 160) {
            this.handleSpace();
        } else if (inputCodePoint == 10) {
            this.handleLineFeed();
        } else {
            this.handleNonSpace(inputCodePoint);
        }
    }

    @NotNull
    public final String get() {
        this.handleSpace();
        String string = this.sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    private final void handleSpace() {
        if (this.wordWidth > 0) {
            if (this.lineWidth > 0) {
                this.applyWordSeparator();
            }
            this.sb.append((CharSequence)this.word);
            this.lineWidth += this.wordWidth;
            TextKt.clear(this.word);
            this.wordWidth = 0;
            this.newLinesSinceLastWord = 0;
        }
    }

    private final void handleLineFeed() {
        this.handleSpace();
        if (this.lineWidth > 0) {
            int n = this.newLinesSinceLastWord;
            this.newLinesSinceLastWord = n + 1;
        }
    }

    private final void handleNonSpace(int inputCodePoint) {
        int outputCodePoint = inputCodePoint == 160 ? 32 : inputCodePoint;
        int charWidth = TextTermKt.codePointWidth(outputCodePoint);
        if (this.lineWidth > 0 && this.lineWidth + 1 + this.wordWidth + charWidth > this.maxWidth) {
            this.goToNewLine();
        }
        if (this.lineWidth == 0 && this.lineWidth + 1 + this.wordWidth + charWidth > this.maxWidth) {
            this.sb.append((CharSequence)this.word);
            TextKt.clear(this.word);
            this.wordWidth = 0;
            this.sb.append("\n");
            this.lineWidth = 0;
        }
        this.word.appendCodePoint(outputCodePoint);
        this.wordWidth += charWidth;
    }

    private final boolean isNewParagraphRequired() {
        return this.newLinesSinceLastWord > 1;
    }

    private final void applyWordSeparator() {
        if (this.isNewParagraphRequired()) {
            this.sb.append("\n\n");
            this.lineWidth = 0;
        } else {
            this.sb.append(" ");
            ++this.lineWidth;
        }
    }

    private final void goToNewLine() {
        if (this.isNewParagraphRequired()) {
            this.sb.append("\n\n");
        } else {
            this.sb.append("\n");
        }
        this.lineWidth = 0;
        this.newLinesSinceLastWord = 0;
    }

    public TextWrapper(int maxWidth) {
        this.maxWidth = maxWidth;
        this.sb = new StringBuilder();
        this.word = new StringBuilder();
    }
}

