/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.xenomachina.text.term;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import shadow.com.xenomachina.text.TextKt;
import shadow.com.xenomachina.text.term.TextWrapper;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0006\u001a\u000e\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a+\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0007\"\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\n\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0005\u001a\u0012\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"SPACE_WIDTH", "", "codePointWidth", "ucs", "columnize", "", "s", "", "minWidths", "", "([Ljava/lang/String;[I)Ljava/lang/String;", "padLinesToWidth", "width", "wrapText", "maxWidth", "xenocom"})
public final class TextTermKt {
    public static final int SPACE_WIDTH = 1;

    @NotNull
    public static final String padLinesToWidth(@NotNull String $receiver, int width) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        StringBuilder sb = new StringBuilder();
        int lineWidth = 0;
        boolean singleLine = true;
        Iterator iterator2 = TextKt.codePointSequence($receiver).iterator();
        while (iterator2.hasNext()) {
            int codePoint = ((Number)iterator2.next()).intValue();
            if (codePoint == 10) {
                singleLine = false;
                while (lineWidth < width) {
                    sb.append(" ");
                    ++lineWidth;
                }
                sb.append("\n");
                lineWidth = 0;
                continue;
            }
            sb.appendCodePoint(codePoint);
            lineWidth += TextTermKt.codePointWidth(codePoint);
        }
        if (singleLine || lineWidth > 0) {
            while (lineWidth < width) {
                sb.append(" ");
                ++lineWidth;
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final String wrapText(@NotNull String $receiver, int maxWidth) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TextWrapper textWrapper = new TextWrapper(maxWidth);
        Iterator iterator2 = TextKt.codePointSequence($receiver).iterator();
        while (iterator2.hasNext()) {
            int inputCodePoint = ((Number)iterator2.next()).intValue();
            textWrapper.addCodePoint(inputCodePoint);
        }
        return textWrapper.get();
    }

    public static final int codePointWidth(int ucs) {
        byte category;
        if (ucs == 0) {
            return 0;
        }
        if (ucs < 32 || ucs >= 127 && ucs < 160) {
            return -1;
        }
        if (ucs != 173 && ((category = (byte)Character.getType(ucs)) == 7 || category == 6 || category == 16 || 4448 <= ucs && ucs <= 4607 || ucs == 8203)) {
            return 0;
        }
        return ucs >= 4352 && (ucs <= 4447 || ucs == 9001 || ucs == 9002 || ucs >= 11904 && ucs <= 42191 && ucs != 12351 || ucs >= 44032 && ucs <= 55203 || ucs >= 63744 && ucs <= 64255 || ucs >= 65040 && ucs <= 65049 || ucs >= 65072 && ucs <= 65135 || ucs >= 65280 && ucs <= 65376 || ucs >= 65504 && ucs <= 65510 || ucs >= 131072 && ucs <= 196605 || ucs >= 196608 && ucs <= 262141) ? 2 : 1;
    }

    /*
     * WARNING - void declaration
     */
    public static final int codePointWidth(@NotNull String $receiver) {
        void var2_2;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Sequence<Integer> $receiver$iv = TextKt.codePointSequence($receiver);
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            int n = ((Number)element$iv).intValue();
            int n2 = sum$iv;
            int n3 = TextTermKt.codePointWidth((int)it);
            sum$iv = n2 + n3;
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String columnize(@NotNull String[] s, @Nullable int[] minWidths) {
        int v$iv;
        Object object;
        Object[] $receiver$iv;
        Object[] line2;
        int $i$f$Array;
        Object[] objectArray;
        int n;
        int i$iv;
        Intrinsics.checkParameterIsNotNull((Object)s, (String)"s");
        int size$iv = ((Object[])s).length;
        List[] result$iv22 = new List[size$iv];
        int n2 = 0;
        int n3 = result$iv22.length;
        while (n2 < n3) {
            List list;
            void var7_16 = i$iv;
            n = i$iv++;
            objectArray = result$iv22;
            objectArray[n] = list = (List)new ArrayList();
        }
        List[] columns = result$iv22;
        int[] widths = new int[((Object[])s).length];
        int result$iv22 = 0;
        i$iv = ((Object[])s).length - 1;
        if (result$iv22 <= i$iv) {
            while (true) {
                void i;
                if (minWidths != null && i < minWidths.length) {
                    widths[i] = minWidths[i];
                }
                for (String line2 : StringsKt.lineSequence((CharSequence)s[i])) {
                    String cell = TextKt.trimNewline(line2);
                    columns[i].add(cell);
                    $i$f$Array = widths[i];
                    int n4 = TextTermKt.codePointWidth(cell);
                    n = i;
                    objectArray = widths;
                    int n5 = Math.max($i$f$Array, n4);
                    objectArray[n] = (List)n5;
                }
                if (i == i$iv) break;
                ++i;
            }
        }
        if ((line2 = ($receiver$iv = (Object[])columns)).length == 0) {
            object = null;
        } else {
            Object maxElem$iv = $receiver$iv[0];
            List it = (List)maxElem$iv;
            int maxValue$iv = it.size();
            int $i$a$1$maxBy = 1;
            $i$f$Array = ArraysKt.getLastIndex((Object[])$receiver$iv);
            if ($i$a$1$maxBy <= $i$f$Array) {
                while (true) {
                    void i$iv2;
                    Object e$iv;
                    List it2;
                    if (maxValue$iv < (v$iv = (it2 = (List)(e$iv = $receiver$iv[i$iv2])).size())) {
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    }
                    if (i$iv2 == $i$f$Array) break;
                    ++i$iv2;
                }
            }
            object = maxElem$iv;
        }
        List list = (List)object;
        int height = list != null ? list.size() : 0;
        StringBuilder sb = new StringBuilder();
        boolean firstLine = true;
        int maxValue$iv = 0;
        int n6 = height - 1;
        if (maxValue$iv <= n6) {
            while (true) {
                void j;
                if (firstLine) {
                    firstLine = false;
                } else {
                    sb.append("\n");
                }
                int lineWidth = 0;
                int columnStart = 0;
                v$iv = 0;
                int n7 = ((Object[])columns).length - 1;
                if (v$iv <= n7) {
                    while (true) {
                        void i;
                        if ((String)CollectionsKt.getOrNull((List)columns[i], (int)j) != null) {
                            String string;
                            String cell = string;
                            int n8 = 1;
                            int n9 = columnStart - lineWidth;
                            if (n8 <= n9) {
                                while (true) {
                                    void k;
                                    sb.append(" ");
                                    if (k == n9) break;
                                    ++k;
                                }
                            }
                            lineWidth = columnStart;
                            sb.append(cell);
                            lineWidth += TextTermKt.codePointWidth(cell);
                        }
                        columnStart += widths[i];
                        if (i == n7) break;
                        ++i;
                    }
                }
                if (j == n6) break;
                ++j;
            }
        }
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ String columnize$default(String[] stringArray, int[] nArray, int n, Object object) {
        if ((n & 2) != 0) {
            nArray = null;
        }
        return TextTermKt.columnize(stringArray, nArray);
    }
}

