/*
 * Decompiled with CFR 0.152.
 */
package org.spekframework.ide;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spekframework.ide.ServiceMessageAdapter;
import org.spekframework.spek2.runtime.execution.ExecutionListener;
import org.spekframework.spek2.runtime.execution.ExecutionResult;
import org.spekframework.spek2.runtime.scope.GroupScopeImpl;
import org.spekframework.spek2.runtime.scope.Path;
import org.spekframework.spek2.runtime.scope.TestScopeImpl;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0016J\u001e\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\u0010\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001a\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u0015\u001a\u0004\u0018\u00010\fH\u0016J\f\u0010\u001d\u001a\u00020\f*\u00020\fH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/spekframework/ide/ServiceMessageAdapter;", "Lorg/spekframework/spek2/runtime/execution/ExecutionListener;", "()V", "durations", "", "Lorg/spekframework/spek2/runtime/scope/Path;", "", "executionFinish", "", "executionStart", "getExceptionDetails", "Lkotlin/Pair;", "", "result", "Lorg/spekframework/spek2/runtime/execution/ExecutionResult$Failure;", "groupExecutionFinish", "group", "Lorg/spekframework/spek2/runtime/scope/GroupScopeImpl;", "Lorg/spekframework/spek2/runtime/execution/ExecutionResult;", "groupExecutionStart", "groupIgnored", "reason", "out", "event", "testExecutionFinish", "test", "Lorg/spekframework/spek2/runtime/scope/TestScopeImpl;", "testExecutionStart", "testIgnored", "toServiceMessageSafeString", "interop-jvm"})
public final class ServiceMessageAdapter
implements ExecutionListener {
    private final Map<Path, Long> durations;

    public void executionStart() {
    }

    public void executionFinish() {
        this.durations.clear();
    }

    public void testExecutionStart(@NotNull TestScopeImpl test) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        Map<Path, Long> map = this.durations;
        Path path = test.getPath();
        Long l = System.currentTimeMillis();
        map.put(path, l);
        this.out("testStarted name='" + this.toServiceMessageSafeString(test.getPath().getName()) + "' locationHint='spek://" + test.getPath().serialize() + '\'');
    }

    public void testExecutionFinish(@NotNull TestScopeImpl test, @NotNull ExecutionResult result) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        String name = this.toServiceMessageSafeString(test.getPath().getName());
        long l = System.currentTimeMillis();
        Long l2 = this.durations.get(test.getPath());
        if (l2 == null) {
            Intrinsics.throwNpe();
        }
        long duration = l - ((Number)l2).longValue();
        if (result instanceof ExecutionResult.Failure) {
            Pair<String, String> exceptionDetails = this.getExceptionDetails((ExecutionResult.Failure)result);
            this.out("testFailed name='" + name + "' duration='" + duration + "' message='" + (String)exceptionDetails.getFirst() + "' details='" + (String)exceptionDetails.getSecond() + '\'');
        }
        this.out("testFinished name='" + name + "' duration='" + duration + '\'');
    }

    public void testIgnored(@NotNull TestScopeImpl test, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull((Object)test, (String)"test");
        String name = this.toServiceMessageSafeString(test.getPath().getName());
        StringBuilder stringBuilder = new StringBuilder().append("testIgnored name='").append(name).append("' ignoreComment='");
        String string = reason;
        if (string == null) {
            string = "no reason provided";
        }
        this.out(stringBuilder.append(string).append('\'').toString());
        this.out("testFinished name='" + name + '\'');
    }

    public void groupExecutionStart(@NotNull GroupScopeImpl group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        this.out("testSuiteStarted name='" + this.toServiceMessageSafeString(group.getPath().getName()) + "' locationHint='spek://" + group.getPath().serialize() + '\'');
    }

    public void groupExecutionFinish(@NotNull GroupScopeImpl group, @NotNull ExecutionResult result) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        String name = this.toServiceMessageSafeString(group.getPath().getName());
        if (result instanceof ExecutionResult.Failure) {
            Pair<String, String> exceptionDetails = this.getExceptionDetails((ExecutionResult.Failure)result);
            this.out("testStarted name='" + name + '\'');
            this.out("testFailed name='" + name + "' message='" + (String)exceptionDetails.getFirst() + "' details='" + (String)exceptionDetails.getSecond() + '\'');
            this.out("testFinished name='" + name + '\'');
        }
        this.out("testSuiteFinished name='" + name + '\'');
    }

    public void groupIgnored(@NotNull GroupScopeImpl group, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        String name = this.toServiceMessageSafeString(group.getPath().getName());
        StringBuilder stringBuilder = new StringBuilder().append("testIgnored name='").append(name).append("' ignoreComment='");
        String string = reason;
        if (string == null) {
            string = "no reason provided";
        }
        this.out(stringBuilder.append(string).append('\'').toString());
        this.out("testFinished name='" + name + '\'');
    }

    private final Pair<String, String> getExceptionDetails(ExecutionResult.Failure result) {
        CharArrayWriter charArrayWriter;
        Throwable throwable = result.getCause();
        CharArrayWriter writer = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        CharArrayWriter it = charArrayWriter = new CharArrayWriter();
        throwable.printStackTrace(new PrintWriter(it));
        String string = it.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
        String details = this.toServiceMessageSafeString(string);
        String string2 = throwable.getMessage();
        String message = string2 != null ? this.toServiceMessageSafeString(string2) : null;
        return TuplesKt.to((Object)message, (Object)details);
    }

    private final String toServiceMessageSafeString(@NotNull String $receiver) {
        CharSequence charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)$receiver, (String)"|", (String)"||", (boolean)false, (int)4, null), (String)"\n", (String)"|n", (boolean)false, (int)4, null), (String)"\r", (String)"|r", (boolean)false, (int)4, null), (String)"'", (String)"|'", (boolean)false, (int)4, null), (String)"[", (String)"|[", (boolean)false, (int)4, null), (String)"]", (String)"|]", (boolean)false, (int)4, null);
        Regex regex = new Regex("\\\\u(\\d\\d\\d\\d)");
        Function1 function1 = toServiceMessageSafeString.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    private final void out(String event) {
        System.out.println();
        String string = "##teamcity[" + event + ']';
        System.out.println((Object)string);
    }

    public ServiceMessageAdapter() {
        Map map;
        ServiceMessageAdapter serviceMessageAdapter = this;
        serviceMessageAdapter.durations = map = (Map)new LinkedHashMap();
    }
}

