/*
 * Decompiled with CFR 0.152.
 */
package org.spekframework.intellij;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinFacetSettingsProvider;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.platform.IdePlatform;
import org.jetbrains.kotlin.platform.IdePlatformKind;
import org.jetbrains.kotlin.platform.impl.CommonIdePlatformKind;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.spekframework.intellij.ProducerType;
import org.spekframework.intellij.ProducerTypeKt;
import org.spekframework.intellij.SpekConfigurationType;
import org.spekframework.intellij.SpekRunConfiguration;
import org.spekframework.intellij.domain.ScopeDescriptor;
import org.spekframework.intellij.domain.ScopeDescriptorCache;
import org.spekframework.intellij.support.SpekCommonProgramRunConfigurationParameters;
import org.spekframework.intellij.util.PsiUtilsKt;
import org.spekframework.spek2.runtime.scope.Path;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J&\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0014\u0010\u0016\u001a\u00020\u00122\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0002J*\u0010\u0019\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lorg/spekframework/intellij/SpekRunConfigurationProducer;", "Lcom/intellij/execution/actions/RunConfigurationProducer;", "Lorg/spekframework/intellij/SpekRunConfiguration;", "producerType", "Lorg/spekframework/intellij/ProducerType;", "type", "Lorg/spekframework/intellij/SpekConfigurationType;", "(Lorg/spekframework/intellij/ProducerType;Lorg/spekframework/intellij/SpekConfigurationType;)V", "getProducerType", "()Lorg/spekframework/intellij/ProducerType;", "findSupportedModule", "Lkotlin/Pair;", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/kotlin/config/KotlinFacetSettings;", "project", "Lcom/intellij/openapi/project/Project;", "commonModule", "isConfigurationFromContext", "", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isPlatformSupported", "kind", "Lorg/jetbrains/kotlin/platform/IdePlatformKind;", "setupConfigurationFromContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "intellij-base"})
public abstract class SpekRunConfigurationProducer
extends RunConfigurationProducer<SpekRunConfiguration<?>> {
    @NotNull
    private final ProducerType producerType;

    public boolean isConfigurationFromContext(@NotNull SpekRunConfiguration<?> configuration, @NotNull ConfigurationContext context) {
        ScopeDescriptor scopeDescriptor;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Object object = context.getProject().getComponent(ScopeDescriptorCache.class);
        if (object == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ScopeDescriptorCache descriptorCache = (ScopeDescriptorCache)object;
        PsiElement psiElement = context.getPsiLocation();
        if (psiElement != null) {
            PsiElement elementContext;
            PsiElement psiElement2;
            PsiElement it;
            PsiElement psiElement3 = it = (psiElement2 = psiElement);
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement3, (String)"it");
            PsiElement psiElement4 = elementContext = PsiUtilsKt.maybeGetContext(psiElement3);
            scopeDescriptor = psiElement4 instanceof KtClassOrObject ? (ScopeDescriptor)descriptorCache.fromClassOrObject((KtClassOrObject)elementContext) : (psiElement4 instanceof KtCallExpression ? descriptorCache.fromCallExpression((KtCallExpression)elementContext) : null);
        } else {
            scopeDescriptor = null;
        }
        ScopeDescriptor descriptor = scopeDescriptor;
        ScopeDescriptor scopeDescriptor2 = descriptor;
        return Intrinsics.areEqual((Object)((SpekCommonProgramRunConfigurationParameters)configuration.getData()).getPath(), (Object)(scopeDescriptor2 != null ? scopeDescriptor2.getPath() : null));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupConfigurationFromContext(@NotNull SpekRunConfiguration<?> configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        boolean bl;
        Path path;
        PsiElement elementContext;
        PsiElement it;
        Intrinsics.checkParameterIsNotNull(configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(sourceElement, (String)"sourceElement");
        Object object = context.getProject().getComponent(ScopeDescriptorCache.class);
        if (object == null) {
            String string = "Required value was null.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        ScopeDescriptorCache descriptorCache = (ScopeDescriptorCache)object;
        Object object2 = sourceElement.get();
        PsiElement psiElement = it = (PsiElement)object2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"it");
        PsiElement psiElement2 = elementContext = PsiUtilsKt.maybeGetContext(psiElement);
        ScopeDescriptor scopeDescriptor = psiElement2 instanceof KtClassOrObject ? (ScopeDescriptor)descriptorCache.fromClassOrObject((KtClassOrObject)elementContext) : (psiElement2 instanceof KtCallExpression ? descriptorCache.fromCallExpression((KtCallExpression)elementContext) : null);
        Object object3 = path = scopeDescriptor != null ? scopeDescriptor.getPath() : null;
        if (path != null) {
            ((SpekCommonProgramRunConfigurationParameters)configuration.getData()).setPath(path);
            Project project = context.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"context.project");
            KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
            Module module = context.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"context.module");
            KotlinFacetSettings kotlinFacetSettings = kotlinFacetSettingsProvider.getInitializedSettings(module);
            boolean canRun = false;
            IdePlatform idePlatform = kotlinFacetSettings.getPlatform();
            if (idePlatform == null) {
                Intrinsics.throwNpe();
            }
            if (this.isPlatformSupported(idePlatform.getKind())) {
                Module module2 = context.getModule();
                Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"context.module");
                configuration.configureForModule(module2);
                canRun = true;
            } else {
                IdePlatform idePlatform2 = kotlinFacetSettings.getPlatform();
                if (idePlatform2 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)idePlatform2.getKind(), (Object)CommonIdePlatformKind.INSTANCE)) {
                    Project project2 = context.getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"context.project");
                    Module module3 = context.getModule();
                    Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"context.module");
                    Pair<Module, KotlinFacetSettings> result = this.findSupportedModule(project2, module3);
                    if (result != null) {
                        void module4;
                        Pair<Module, KotlinFacetSettings> pair = result;
                        psiElement2 = (Module)pair.component1();
                        KotlinFacetSettings moduleKotlinFacetSettings = (KotlinFacetSettings)pair.component2();
                        configuration.configureForModule((Module)module4);
                        Object obj = configuration.getData();
                        IdePlatform idePlatform3 = moduleKotlinFacetSettings.getPlatform();
                        if (idePlatform3 == null) {
                            Intrinsics.throwNpe();
                        }
                        ((SpekCommonProgramRunConfigurationParameters)obj).setProducerType(ProducerTypeKt.toProducerType(idePlatform3.getKind()));
                        canRun = true;
                    }
                }
            }
            bl = canRun;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Module, KotlinFacetSettings> findSupportedModule(Project project, Module commonModule) {
        Object v1;
        block3: {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            KotlinFacetSettingsProvider kotlinFacetSettingsProvider = KotlinFacetSettingsProvider.Companion.getInstance(project);
            Iterable iterable = MultiplatformUtilKt.getImplementingModules((Module)commonModule);
            Iterator iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Module module = (Module)item$iv$iv;
                Collection collection = destination$iv$iv;
                Pair pair = TuplesKt.to((Object)it, (Object)kotlinFacetSettingsProvider.getInitializedSettings((Module)it));
                collection.add(pair);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                Pair it = (Pair)element$iv;
                IdePlatform idePlatform = ((KotlinFacetSettings)it.getSecond()).getPlatform();
                if (idePlatform == null) {
                    Intrinsics.throwNpe();
                }
                if (!this.isPlatformSupported(idePlatform.getKind())) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        return v1;
    }

    private final boolean isPlatformSupported(IdePlatformKind<?> kind) {
        return ProducerTypeKt.toProducerType(kind) == this.producerType;
    }

    @NotNull
    public final ProducerType getProducerType() {
        return this.producerType;
    }

    public SpekRunConfigurationProducer(@NotNull ProducerType producerType, @NotNull SpekConfigurationType type2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)producerType), (String)"producerType");
        Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
        super((ConfigurationType)type2);
        this.producerType = producerType;
    }
}

