/*
 * Decompiled with CFR 0.152.
 */
package org.spekframework.intellij;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spekframework.intellij.SpekBaseJvmRunConfiguration;
import org.spekframework.intellij.SpekJvmSettingsEditor;
import org.spekframework.intellij.SpekRunnnerCommandLineState;
import org.spekframework.intellij.support.SpekJvmCommonRunConfigurationParameters;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00170\u0016H\u0016J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"H\u0016R\u0014\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006$"}, d2={"Lorg/spekframework/intellij/SpekJvmRunConfiguration;", "Lcom/intellij/execution/configurations/ModuleBasedConfiguration;", "Lcom/intellij/execution/configurations/JavaRunConfigurationModule;", "Lcom/intellij/execution/configurations/RunConfigurationOptions;", "Lorg/spekframework/intellij/SpekBaseJvmRunConfiguration;", "name", "", "module", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "(Ljava/lang/String;Lcom/intellij/execution/configurations/JavaRunConfigurationModule;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "configurationModule", "getConfigurationModule", "()Lcom/intellij/execution/configurations/JavaRunConfigurationModule;", "data", "Lorg/spekframework/intellij/support/SpekJvmCommonRunConfigurationParameters;", "getData", "()Lorg/spekframework/intellij/support/SpekJvmCommonRunConfigurationParameters;", "configureForModule", "", "Lcom/intellij/openapi/module/Module;", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getValidModules", "", "readExternal", "element", "Lorg/jdom/Element;", "writeExternal", "intellij-idea"})
public final class SpekJvmRunConfiguration
extends ModuleBasedConfiguration<JavaRunConfigurationModule, RunConfigurationOptions>
implements SpekBaseJvmRunConfiguration {
    @NotNull
    private final SpekJvmCommonRunConfigurationParameters data;

    @NotNull
    public SpekJvmCommonRunConfigurationParameters getData() {
        return this.data;
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        return new SpekJvmSettingsEditor(project);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        return (RunProfileState)new SpekRunnnerCommandLineState<RunConfigurationBase>(environment, (RunConfigurationBase)this);
    }

    @NotNull
    public Collection<Module> getValidModules() {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.getProject());
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        return CollectionsKt.mutableListOf((Object[])Arrays.copyOf(moduleArray, moduleArray.length));
    }

    @NotNull
    public JavaRunConfigurationModule getConfigurationModule() {
        RunConfigurationModule runConfigurationModule = super.getConfigurationModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)runConfigurationModule, (String)"super.getConfigurationModule()");
        return (JavaRunConfigurationModule)runConfigurationModule;
    }

    public void configureForModule(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        this.setModule(module);
        this.setGeneratedName();
    }

    public void writeExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.writeExternal(element);
        this.getData().writeExternal(element);
    }

    public void readExternal(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        super.readExternal(element);
        this.getData().readExternal(element);
    }

    public SpekJvmRunConfiguration(@NotNull String name, @NotNull JavaRunConfigurationModule module, @NotNull ConfigurationFactory factory) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Intrinsics.checkParameterIsNotNull((Object)factory, (String)"factory");
        super(name, (RunConfigurationModule)module, factory);
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        this.data = new SpekJvmCommonRunConfigurationParameters(project);
    }

    @NotNull
    public String suggestedName() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.suggestedName((SpekBaseJvmRunConfiguration)this);
    }

    @Nullable
    public String getAlternativeJrePath() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getAlternativeJrePath((SpekBaseJvmRunConfiguration)this);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getEnvs((SpekBaseJvmRunConfiguration)this);
    }

    @Nullable
    public String getPackage() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getPackage((SpekBaseJvmRunConfiguration)this);
    }

    @Nullable
    public String getProgramParameters() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getProgramParameters((SpekBaseJvmRunConfiguration)this);
    }

    @Nullable
    public String getRunClass() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getRunClass((SpekBaseJvmRunConfiguration)this);
    }

    @NotNull
    public String getVMParameters() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getVMParameters((SpekBaseJvmRunConfiguration)this);
    }

    @Nullable
    public String getWorkingDirectory() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.getWorkingDirectory((SpekBaseJvmRunConfiguration)this);
    }

    public boolean isAlternativeJrePathEnabled() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.isAlternativeJrePathEnabled((SpekBaseJvmRunConfiguration)this);
    }

    public boolean isPassParentEnvs() {
        return SpekBaseJvmRunConfiguration.DefaultImpls.isPassParentEnvs((SpekBaseJvmRunConfiguration)this);
    }

    public void setAlternativeJrePath(@Nullable String path) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setAlternativeJrePath((SpekBaseJvmRunConfiguration)this, (String)path);
    }

    public void setAlternativeJrePathEnabled(boolean enabled) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setAlternativeJrePathEnabled((SpekBaseJvmRunConfiguration)this, (boolean)enabled);
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        Intrinsics.checkParameterIsNotNull(envs, (String)"envs");
        SpekBaseJvmRunConfiguration.DefaultImpls.setEnvs((SpekBaseJvmRunConfiguration)this, envs);
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setPassParentEnvs((SpekBaseJvmRunConfiguration)this, (boolean)passParentEnvs);
    }

    public void setProgramParameters(@Nullable String programParameters) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setProgramParameters((SpekBaseJvmRunConfiguration)this, (String)programParameters);
    }

    public void setVMParameters(@Nullable String vmParameters) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setVMParameters((SpekBaseJvmRunConfiguration)this, (String)vmParameters);
    }

    public void setWorkingDirectory(@Nullable String value) {
        SpekBaseJvmRunConfiguration.DefaultImpls.setWorkingDirectory((SpekBaseJvmRunConfiguration)this, (String)value);
    }
}

