/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph.utils;

import io.github.classgraph.utils.FastPathResolver;
import io.github.classgraph.utils.LogNode;
import io.github.classgraph.utils.VersionFinder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.Arrays;

public class FileUtils {
    public static final String CURR_DIR_PATH;
    public static final int FILECHANNEL_FILE_SIZE_THRESHOLD;
    private static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFFF7;
    private static final int MAX_INITIAL_BUFFER_SIZE = 0x1000000;

    private static AbstractMap.SimpleEntry<byte[], Integer> readAllBytes(InputStream inputStream, long fileSizeHint, LogNode log) throws IOException {
        if (fileSizeHint > 0x7FFFFFF7L) {
            throw new IOException("InputStream is too large to read");
        }
        int bufferSize = fileSizeHint < 1L ? 16384 : Math.min((int)fileSizeHint, 0x1000000);
        byte[] buf = new byte[bufferSize];
        int bufLength = buf.length;
        int totBytesRead = 0;
        while (true) {
            int bytesRead;
            if ((bytesRead = inputStream.read(buf, totBytesRead, bufLength - totBytesRead)) > 0) {
                totBytesRead += bytesRead;
                continue;
            }
            if (bytesRead < 0) break;
            if (bufLength <= 0x7FFFFFF7 - bufLength) {
                bufLength <<= 1;
            } else {
                if (bufLength == 0x7FFFFFF7) {
                    throw new IOException("InputStream too large to read");
                }
                bufLength = 0x7FFFFFF7;
            }
            buf = Arrays.copyOf(buf, bufLength);
        }
        return new AbstractMap.SimpleEntry<byte[], Integer>(bufLength == totBytesRead ? buf : Arrays.copyOf(buf, totBytesRead), totBytesRead);
    }

    public static byte[] readAllBytesAsArray(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        int bufBytesUsed;
        AbstractMap.SimpleEntry<byte[], Integer> ent = FileUtils.readAllBytes(inputStream, fileSize, log);
        byte[] buf = ent.getKey();
        return buf.length == (bufBytesUsed = ent.getValue().intValue()) ? buf : Arrays.copyOf(buf, bufBytesUsed);
    }

    public static String readAllBytesAsString(InputStream inputStream, long fileSize, LogNode log) throws IOException {
        AbstractMap.SimpleEntry<byte[], Integer> ent = FileUtils.readAllBytes(inputStream, fileSize, log);
        byte[] buf = ent.getKey();
        int bufBytesUsed = ent.getValue();
        return new String(buf, 0, bufBytesUsed, "UTF-8");
    }

    public static InputStream byteBufferToInputStream(final ByteBuffer byteBuffer) {
        return new InputStream(){
            final ByteBuffer buf;
            {
                this.buf = byteBuffer;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                int bytesRead = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, bytesRead);
                return bytesRead;
            }
        };
    }

    public static boolean isClassfile(String path) {
        int len = path.length();
        return len > 6 && path.regionMatches(true, len - 6, ".class", 0, 6);
    }

    public static boolean canRead(File file) {
        try {
            return file.canRead();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    static {
        String currDirPathStr = "";
        try {
            Path currDirPath = Paths.get("", new String[0]).toAbsolutePath();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.normalize();
            currDirPathStr = currDirPath.toString();
            currDirPath = currDirPath.toRealPath(LinkOption.NOFOLLOW_LINKS);
            currDirPathStr = currDirPath.toString();
            currDirPathStr = FastPathResolver.resolve(currDirPathStr);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not resolve current directory: " + currDirPathStr, e);
        }
        CURR_DIR_PATH = currDirPathStr;
        switch (VersionFinder.OS) {
            case Linux: {
                FILECHANNEL_FILE_SIZE_THRESHOLD = 16384;
                break;
            }
            case Windows: {
                FILECHANNEL_FILE_SIZE_THRESHOLD = 16384;
                break;
            }
            case MacOSX: {
                FILECHANNEL_FILE_SIZE_THRESHOLD = Integer.MAX_VALUE;
                break;
            }
            default: {
                FILECHANNEL_FILE_SIZE_THRESHOLD = 16384;
            }
        }
    }
}

