/*
 * Decompiled with CFR 0.152.
 */
package io.github.classgraph;

import io.github.classgraph.ClassInfo;
import io.github.classgraph.ScanResult;
import java.util.Set;

abstract class ScanResultObject {
    protected transient ScanResult scanResult;
    private transient ClassInfo classInfo;

    ScanResultObject() {
    }

    void setScanResult(ScanResult scanResult) {
        this.scanResult = scanResult;
    }

    abstract void getClassNamesFromTypeDescriptors(Set<String> var1);

    protected abstract String getClassName();

    ClassInfo getClassInfo() {
        if (this.classInfo == null) {
            if (this.scanResult == null) {
                return null;
            }
            String className = this.getClassName();
            if (className == null) {
                throw new IllegalArgumentException("Class name is not set");
            }
            this.classInfo = this.scanResult.getClassInfo(className);
            if (this.classInfo == null) {
                return null;
            }
        }
        return this.classInfo;
    }

    <T> Class<T> loadClass(Class<T> superclassOrInterfaceType, boolean ignoreExceptions) {
        ClassInfo classInfo = this.getClassInfo();
        String className = classInfo != null ? classInfo.getName() : this.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("Class name is not set");
        }
        return this.scanResult.loadClass(className, superclassOrInterfaceType, ignoreExceptions);
    }

    <T> Class<T> loadClass(Class<T> superclassOrInterfaceType) {
        return this.loadClass(superclassOrInterfaceType, false);
    }

    Class<?> loadClass(boolean ignoreExceptions) {
        ClassInfo classInfo = this.getClassInfo();
        String className = classInfo != null ? classInfo.getName() : this.getClassName();
        if (className == null) {
            throw new IllegalArgumentException("Class name is not set");
        }
        return this.scanResult.loadClass(className, ignoreExceptions);
    }

    Class<?> loadClass() {
        return this.loadClass(false);
    }
}

