package com.example.time_tracking

import Entry
import EntryAdapter
import android.content.Intent
import android.os.Bundle
import android.widget.Button
import androidx.appcompat.app.AppCompatActivity
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView

// ViewEntriesActivity.kt

class ViewEntriesActivity : AppCompatActivity() {

    private lateinit var rvEntries: RecyclerView

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.view_entry_activity)

        rvEntries = findViewById(R.id.rvEntries)
        rvEntries.layoutManager = LinearLayoutManager(this)

        val entries = getEntries() // Replace this with your method to fetch entries

        val adapter = EntryAdapter(entries)
        rvEntries.adapter = adapter

        val btnBackToMenu: Button = findViewById(R.id.btnBackToMenu)
        btnBackToMenu.setOnClickListener {
            // Navigate back to the menu activity
            val intent = Intent(this, MenuActivity::class.java)
            startActivity(intent)
            finish() // Optional: Close the current activity
        }
    }

    private fun getEntries(): List<Entry> {
        // Assuming you have a list of pre-defined entries for demonstration
        val entryList = mutableListOf<Entry>()

        // Adding dummy entries for demonstration
        entryList.add(Entry("2024-04-23", "09:00", "17:00", "Work on project", "Work"))
        entryList.add(Entry("2024-04-24", "10:00", "18:00", "Meeting with client", "Meeting"))
        entryList.add(Entry("2024-04-25", "08:30", "16:30", "Review documentation", "Work"))

        return entryList
    }

}
