package com.example.time_tracking

import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.widget.Button
import android.widget.EditText
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import java.text.SimpleDateFormat
import java.util.*
import kotlin.properties.Delegates

data class TimesheetEntry(
    val id: Long,
    val date: Date,
    val startTime: Date,
    val endTime: Date,
    val description: String,
    val categoryId: Long,
    val photoPath: String?
)

class TimesheetEntryActivity : AppCompatActivity() {

    private lateinit var etDate: EditText
    private lateinit var etStartTime: EditText
    private lateinit var etEndTime: EditText
    private lateinit var etDescription: EditText
    private lateinit var btnSaveEntry: Button
    private var selectedCategoryId by Delegates.notNull<Long>() // Placeholder for category ID
    private lateinit var currentPhotoPath: String // Placeholder for photo path

    @SuppressLint("MissingInflatedId")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.timesheet_activity)

        // Initialize views
        etDate = findViewById(R.id.etDate)
        etStartTime = findViewById(R.id.etStartTime)
        etEndTime = findViewById(R.id.etEndTime)
        etDescription = findViewById(R.id.etDescription)
        btnSaveEntry = findViewById(R.id.btnSaveEntry)

        // Example of setting current date as default in the date EditText
        val currentDate = SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).format(Date())
        etDate.setText(currentDate)

        // Example of setting current time as default in the start and end time EditTexts
        val currentTime = SimpleDateFormat("HH:mm", Locale.getDefault()).format(Date())
        etStartTime.setText(currentTime)
        etEndTime.setText(currentTime)

        // Set listener for the Save Entry button
        btnSaveEntry.setOnClickListener {
            saveTimesheetEntry()
        }

        // Back to menu button click listener
        val btnBackToMenu: Button = findViewById(R.id.btnBackToMenu)
        btnBackToMenu.setOnClickListener {
            // Navigate back to the menu activity
            val intent = Intent(this, MenuActivity::class.java)
            startActivity(intent)
            finish() // Optional: Close the current activity
        }
    }

    private fun saveTimesheetEntry() {
        // Get values from EditTexts
        val date = getDateFromEditText(etDate)
        val startTime = getTimeFromEditText(etStartTime)
        val endTime = getTimeFromEditText(etEndTime)
        val description = etDescription.text.toString()

        // Here you can validate the data and perform any necessary checks

        // Create TimesheetEntry object
        val timesheetEntry = TimesheetEntry(
            id = 0, // Placeholder for new entry, assuming it doesn't have an ID yet
            date = date,
            startTime = startTime,
            endTime = endTime,
            description = description,
            categoryId = selectedCategoryId, // Placeholder for category ID
            photoPath = currentPhotoPath // Placeholder for photo path
        )

        // Here you can save the timesheet entry to a database or perform any other actions
        // For demonstration purposes, let's just display a Toast message
        Toast.makeText(this, "Timesheet entry saved!", Toast.LENGTH_SHORT).show()
    }

    private fun getDateFromEditText(editText: EditText): Date {
        val dateString = editText.text.toString()
        return SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).parse(dateString)
    }

    private fun getTimeFromEditText(editText: EditText): Date {
        val timeString = editText.text.toString()
        return SimpleDateFormat("HH:mm", Locale.getDefault()).parse(timeString)
    }
}


