/*
 * Decompiled with CFR 0.152.
 */
package com.example.time_tracking;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.example.time_tracking.MenuActivity;
import com.example.time_tracking.R;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.FirebaseFirestore;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/example/time_tracking/LoginActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "()V", "btnLogin", "Landroid/widget/Button;", "db", "Lcom/google/firebase/firestore/FirebaseFirestore;", "etPassword", "Landroid/widget/EditText;", "etUsername", "addUserToDatabase", "", "username", "", "password", "isValidPassword", "", "isValidUsername", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "app_debug"})
@SourceDebugExtension(value={"SMAP\nLoginActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LoginActivity.kt\ncom/example/time_tracking/LoginActivity\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n1083#2,2:81\n*S KotlinDebug\n*F\n+ 1 LoginActivity.kt\ncom/example/time_tracking/LoginActivity\n*L\n51#1:81,2\n*E\n"})
public final class LoginActivity
extends AppCompatActivity {
    private Button btnLogin;
    private EditText etPassword;
    private EditText etUsername;
    private FirebaseFirestore db;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_login);
        View view = this.findViewById(R.id.btnLogin);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"findViewById(...)");
        this.btnLogin = (Button)view;
        View view2 = this.findViewById(R.id.etPassword);
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"findViewById(...)");
        this.etPassword = (EditText)view2;
        View view3 = this.findViewById(R.id.etUsername);
        Intrinsics.checkNotNullExpressionValue((Object)view3, (String)"findViewById(...)");
        this.etUsername = (EditText)view3;
        FirebaseFirestore firebaseFirestore = FirebaseFirestore.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)firebaseFirestore, (String)"getInstance(...)");
        this.db = firebaseFirestore;
        Button button = this.btnLogin;
        if (button == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"btnLogin");
            button = null;
        }
        button.setOnClickListener(arg_0 -> LoginActivity.onCreate$lambda$0(this, arg_0));
    }

    private final boolean isValidUsername(String username) {
        return username.length() > 5;
    }

    private final boolean isValidPassword(String password) {
        boolean containsNumber;
        block2: {
            boolean bl;
            CharSequence $this$any$iv = password;
            boolean $i$f$any = false;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!Character.isDigit(it)) continue;
                bl = true;
                break block2;
            }
            bl = containsNumber = false;
        }
        if (!containsNumber) {
            Toast.makeText((Context)((Context)this), (CharSequence)"No digits found in password", (int)0).show();
            return false;
        }
        Regex passwordRegex = new Regex("^(?=.*[!@#$%^&*])(?=\\S+$).{8,}$");
        return passwordRegex.matches((CharSequence)password);
    }

    private final void addUserToDatabase(String username, String password) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"username", (Object)username), TuplesKt.to((Object)"password", (Object)password)};
        HashMap user = MapsKt.hashMapOf((Pair[])pairArray);
        FirebaseFirestore firebaseFirestore = this.db;
        if (firebaseFirestore == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
            firebaseFirestore = null;
        }
        firebaseFirestore.collection("users").add((Object)user).addOnSuccessListener(arg_0 -> LoginActivity.addUserToDatabase$lambda$2((Function1)new Function1<DocumentReference, Unit>(this){
            final /* synthetic */ LoginActivity this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(DocumentReference documentReference) {
                Toast.makeText((Context)((Context)this.this$0), (CharSequence)("User added successfully with ID: " + documentReference.getId()), (int)0).show();
            }
        }, arg_0)).addOnFailureListener(arg_0 -> LoginActivity.addUserToDatabase$lambda$3(this, arg_0));
    }

    private static final void onCreate$lambda$0(LoginActivity this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        EditText editText = this$0.etUsername;
        if (editText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"etUsername");
            editText = null;
        }
        String username = editText.getText().toString();
        EditText editText2 = this$0.etPassword;
        if (editText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"etPassword");
            editText2 = null;
        }
        String password = editText2.getText().toString();
        if (this$0.isValidUsername(username) && this$0.isValidPassword(password)) {
            this$0.addUserToDatabase(username, password);
            this$0.startActivity(new Intent((Context)this$0, MenuActivity.class));
            this$0.finish();
        } else {
            Toast.makeText((Context)((Context)this$0), (CharSequence)"Invalid username or password", (int)0).show();
        }
    }

    private static final void addUserToDatabase$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void addUserToDatabase$lambda$3(LoginActivity this$0, Exception e) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Toast.makeText((Context)((Context)this$0), (CharSequence)("Error adding user: " + e), (int)0).show();
    }
}

